/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.heroku.ui.wizard;

import com.aptana.deploy.ILoginValidator;
import com.aptana.deploy.heroku.HerokuAPI;
import com.aptana.deploy.heroku.ui.wizard.HerokuDeployWizardPage;
import com.aptana.deploy.heroku.ui.wizard.HerokuSignupPage;
import com.aptana.deploy.heroku.ui.wizard.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class HerokuLoginWizardPage
extends WizardPage
implements ILoginValidator {
    private static final String NAME = "HerokuLogin";
    private Text userId;
    private Text password;
    private IWizardPage fNextPage;

    protected HerokuLoginWizardPage() {
        super(NAME, Messages.HerokuLoginWizardPage_Title, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(composite, 0);
        label.setText(Messages.HerokuLoginWizardPage_EnterCredentialsLabel);
        Composite credentials = new Composite(composite, 0);
        credentials.setLayout((Layout)new GridLayout(2, false));
        Label userIdLabel = new Label(credentials, 0);
        userIdLabel.setText(Messages.HerokuLoginWizardPage_UserIDLabel);
        this.userId = new Text(credentials, 2052);
        this.userId.setMessage(Messages.HerokuLoginWizardPage_UserIDExample);
        GridData gd = new GridData(300, -1);
        this.userId.setLayoutData((Object)gd);
        this.userId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HerokuLoginWizardPage.this.getContainer().updateButtons();
            }
        });
        Label passwordLabel = new Label(credentials, 0);
        passwordLabel.setText(Messages.HerokuLoginWizardPage_PasswordLabel);
        this.password = new Text(credentials, 0x400804);
        this.password.setMessage(Messages.HerokuLoginWizardPage_PasswordExample);
        this.password.setLayoutData((Object)gd);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HerokuLoginWizardPage.this.getContainer().updateButtons();
            }
        });
        Button checkAuth = new Button(credentials, 8);
        checkAuth.setText(Messages.HerokuLoginWizardPage_SubmitButtonLabel);
        checkAuth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HerokuLoginWizardPage.this.validateLogin() && HerokuLoginWizardPage.this.isPageComplete()) {
                    HerokuLoginWizardPage.this.getContainer().showPage(HerokuLoginWizardPage.this.getNextPage());
                }
            }
        });
        Link link = new Link(composite, 0);
        link.setText(Messages.HerokuLoginWizardPage_SignupLink);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HerokuSignupPage signupPage = new HerokuSignupPage(HerokuLoginWizardPage.this.userId.getText());
                signupPage.setWizard(HerokuLoginWizardPage.this.getWizard());
                HerokuLoginWizardPage.this.getContainer().showPage((IWizardPage)signupPage);
            }
        });
        Dialog.applyDialogFont((Control)composite);
        IWizardContainer container = this.getWizard().getContainer();
        ((IPageChangeProvider)container).addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                Object selected = event.getSelectedPage();
                if (selected instanceof HerokuDeployWizardPage) {
                    HerokuAPI api = new HerokuAPI(HerokuLoginWizardPage.this.userId.getText(), HerokuLoginWizardPage.this.password.getText());
                    api.writeCredentials();
                }
            }
        });
    }

    public IWizardPage getNextPage() {
        if (this.fNextPage == null) {
            this.fNextPage = new HerokuDeployWizardPage();
            this.fNextPage.setWizard(this.getWizard());
        }
        return this.fNextPage;
    }

    public boolean isPageComplete() {
        String userId = this.userId.getText();
        if (userId == null || userId.trim().length() < 1) {
            this.setErrorMessage(Messages.HerokuLoginWizardPage_EmptyUserIDError);
            return false;
        }
        String password = this.password.getText();
        if (password == null || password.trim().length() < 1) {
            this.setErrorMessage(Messages.HerokuLoginWizardPage_EmptyPasswordError);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean validateLogin() {
        HerokuAPI api = new HerokuAPI(this.userId.getText(), this.password.getText());
        IStatus status = api.authenticate();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }
}

